﻿#if       !defined(INCLUDED_SZ_GET_PASSWORD_CLIENT_CALLBACK)
#define            INCLUDED_SZ_GET_PASSWORD_CLIENT_CALLBACK

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

SZ_NS_BEG(szpp)

/// <summary>
/// パスワードが必要になったときに SevenZip++ がクライアントに問い合わせるためのコールバック型。
/// クライアント側で派生クラスを実装して、そのポインタを SevenZip++ に登録する。
/// </summary>
class SZ_SPEC GetPasswordClientCallback
{
public:

  /// <summary>
  /// パスワード入力のユーザーインターフェースを表示するなどして、ユーザーからパスワードを取得するメソッド。
  /// </summary>
  /// <returns>
  /// メソッドが成功すれば S_OK を返し、ユーザーがキャンセルボタンを押したようなケースでは E_ABORT を返す。
  /// </returns>
  /// <remarks>
  /// ユーザーがコマンドラインオプションでパスワードを指定したような場合には、ユーザーに問い合わせをしなくてもパスワードを持っているので、それを返せばよい。
  /// </remarks>
  virtual HRESULT GetPassword(szstring *password) = 0;

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_GET_PASSWORD_CLIENT_CALLBACK)
